/**
 * tip manager
 * @author sunnyjiang
 * @version 1.0
 */

var tipManager = {};

tipManager.tooltipId = null;

tipManager.init = function() {	
	tipManager.bindMouseOver();

	tipManager.bindClick();
};

tipManager.timer = null;

// 事件绑定
tipManager.bind = function(elementId, eventType) {
	
	var element = $('#' + elementId);
	
	element.bind(eventType, function() {
		// 清除之前的tips显示
		clearTimeout(tipManager.timer);
		
		if(eventType == 'mouseover') {
			// 延时显示tips
			tipManager.timer = setTimeout('tipManager.showTip("' + elementId + '", "' + eventType + '")', 500);
		} else {
			tipManager.showTip(elementId, eventType);
		}
	});
};

// TODO refactoring
// 控制tooltip显示
tipManager.showTip = function(elementId, eventType, tooltipType, tabTitle, pageX, pageY, elementWidth, elementHeight) {
//	alert([elementId, eventType, tabTitle, pageX, pageY, elementWidth, elementHeight]);
	try
	{
		var element = elementId ? $('#' + elementId) : null;	
		
		var tipsOffset = 4;	
		
		if(view.isButtonDisabled(this)) { // button disable时不处理
			return;
		}
	
		var offset = {};
		var height = 0;
		var width = 0;
	
		var title = '';
		var content = '';
		var type = '';
		var url = '';
		
		var trackRect = {};	
		var popRect = {};	
	
		if(tooltipType == 'closeTabButtonTooltip') { // tab close button
			title = element.is('.sel') ? '关闭当前页' : '关闭';
			
			offset = {left: pageX, top: pageY};
			height = elementHeight;
			width = elementWidth;	
			
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};	
		} else if(tooltipType == 'tabTooltip') { // tab上显示title时			
			var maxTabWidth = utils.fromPx2Int(element.css('max-width'));
			tipsOffset = 5;
			
			var titleElement = $(' div.title', element);

			if(titleElement.width() == titleElement.get(0).scrollWidth) { // 未压缩时不显示tooltip
				return;
			}
			content = tabTitle;
	
			height = 24;
			width = 24;		
			offset = {left: pageX - tipsOffset, top: pageY - tipsOffset};	
			
			// 鼠标在此范围内，tooltip弹出，鼠标在此范围之内，tooltip不消失
			// 控制是否弹出
			trackRect = {topLeftX: element.offset().left, topLeftY: element.offset().top, bottomRightX: element.offset().left + element.width(), bottomRightY: element.offset().top + element.height()};			
		} else if(tooltipType == 'favTooltip') {
			content = tabTitle;
			url = element.attr('url');
			
			height = 24;
			width = 24;		
			offset = {left: pageX - tipsOffset, top: pageY - tipsOffset};	
			
			trackRect = {topLeftX: element.offset().left, topLeftY: element.offset().top, bottomRightX: element.offset().left + element.width(), bottomRightY: element.offset().top + element.height()};						
//			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		} else {
			var tipsData = tipManager.data[elementId][eventType];
			
			title = tipsData.constructor == window.Array ? tipsData[0] : '';
			content = tipsData.constructor == window.Array ? tipsData[1] : tipsData;
	
			type = tipsData.constructor == window.Array ? (tipsData[2] ? tipsData[2] : '') : ''; // 区分两种tooltip类型
	
			offset = element.offset();
			height = element.outerHeight();
			width = element.outerWidth();
			
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};			
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		}
	
		var params = {'title': title, 'content': content, 'type': type, 'url': url};
		// 控制tooltip弹出位置，tooltip会在此区域外弹出
		// 控制弹出的位置
		
		// TODO 应该修改engine button的实现逻辑，统一为一个按钮
		if(eventType == 'click') { // 防止另外按钮的mouseover盖住click的tips，取消绑定，下面会重新绑定
			tipManager.unbindEngineMouseOver();
		}
	
		tipManager.tooltipId = browser.tooltip.create(popRect, trackRect, params, function() {});
	
		// 如果没有click tips, click时应该让tips消失
		if(eventType != 'click' && tipManager.data.hasOwnProperty(elementId) && !tipManager.data[elementId]['click']) {
			$(this).one('click', function() {
				browser.tooltip.destroy(tipManager.tooltipId);
			});	
		}
		
		if(eventType == 'click') {
			setTimeout("browser.tooltip.destroy(" + tipManager.tooltipId + "); tipManager.bindEngineMouseOver()", 2000);
		}
		
//		element.one('mouseout', function() {
//			browser.tooltip.destroy(tipManager.tooltipId);
//			clearTimeout(tipManager.timer);
//		});

	}
	catch (e)
	{
		//alert(e.name + e.message);
	}
};

tipManager.data = {
	'skin-button': {
		'mouseover': '换肤'
	},
	'feedback-button': {
		'mouseover': '反馈建议'
	},
	'menu-button': {
		'mouseover': '主菜单'
	},
	'min-button': {
		'mouseover': '最小化'
	},
	'restore-button': {
		'mouseover': '还原'
	},
	'max-button': {
		'mouseover': '最大化'
	},
	'close-button': {
		'mouseover': '退出'
	},
	'back-button': {
		'mouseover': '后退'
	},
	'forward-button': {
		'mouseover': '前进'
	},
	'undo-button': {
		'mouseover': '恢复最近关闭页面'
	},
	'undo-list-button': {
		'mouseover': '恢复最近关闭页面'
	},
	'home-button': {
		'mouseover': '主页'
	},
	'fav-button': {
		'mouseover': '收藏'
	},
	'refresh-button': {
		'mouseover': '刷新'
	},
	'stop-button': {
		'mouseover': '停止加载'
	},
	'address-go-button': {
		'mouseover': '转到'
	},
	'engine-ie-button': {
		'click': ['', '已切换至极速模式<br />如浏览过程出现异常，尝试恢复兼容模式', 'l'], // l表示为large格式
		'mouseover': ['', '当前为兼容模式<br />可点击尝试切换到极速模式', 'l']
	},	
	'engine-webkit-button': {
		'click': ['', '已切换至兼容模式', 'l'],
		'mouseover': ['', '当前为极速模式<br />如浏览出现异常，可点击切换到兼容模式', 'l']
	},
	'clean-button': {
		'mouseover': '清理浏览痕迹'
	},
	'capture-button': {
		'mouseover': '截屏F10'
	},
	'useful-menu-button': {
		'mouseover': '常用菜单'
	},
	'sidebar-show-button': {
		'mouseover': '侧边栏展开'
	},
	'sidebar-hide-button': {
		'mouseover': '侧边栏收起'
	},
	'zoom-box': {
		'mouseover': '网页缩放'
	},
	'screen-box': {
		'mouseover': '弹窗拦截'
	},
	'address-list-button': {
		'mouseover': '存放已经打开过的网址列表，点击后可以直接打开网址无需输入。'
	},
	'new-tab-button':{
		'mouseover': '新标签页'
	},
	'foreground-button':{
		'mouseover': '打开链接时转到新页面'
	},
	'background-button':{
		'mouseover': '打开链接时继续留在当前页面'
	},
	'download-display':{
		'mouseover': '下载'
	},
	'sidebar-qzone-button':{
		'mouseover': 'QQ空间'
	},
	'sidebar-stock-button':{
		'mouseover': '股票行情'
	},
	'sidebar-weibo-button':{
		'mouseover': '腾讯微博'
	},
	'sidebar-doubanfm-button':{
		'mouseover': '豆瓣电台'
	}
};

tipManager.bindMouseOver = function() {
	tipManager.bindEvent('mouseover');
};

tipManager.unbindMouseOver = function() {
	tipManager.unbindEvent('mouseover');
};

tipManager.bindEngineMouseOver = function() {
	tipManager.bind('engine-ie-button', 'mouseover');
	tipManager.bind('engine-webkit-button', 'mouseover');
};

tipManager.unbindEngineMouseOver = function() {
	$('#engine-ie-button').unbind('mouseover');
	$('#engine-webkit-button').unbind('mouseover');
};

tipManager.bindClick = function() {
	tipManager.bindEvent('click');
};

tipManager.unbindEvent = function(eventType) {
	tipManager.toggleEvent(eventType, 'unbind');
};

tipManager.bindEvent = function(eventType) {
	tipManager.toggleEvent(eventType, 'bind');
};

// eventType: mouseover, click...
// toggleType: bind, unbind
tipManager.toggleEvent = function(eventType, toggleType) {
	for(var elementId in tipManager.data) {
		if(tipManager.data[elementId][eventType]) {
			if(toggleType == 'unbind') {
				$('#' + elementId).unbind(eventType);
			} else {
				tipManager.bind(elementId, eventType);
			}
		}
	}
};

tipManager.hideTooltip = function() {
	clearTimeout(tipManager.timer);
	
	browser.tooltip.destroy(tipManager.tooltipId);
};

// 显示标签的tooltip
tipManager.showTabTip = function(tab, event) {
	clearTimeout(tipManager.timer);	
	
	var tabId = tab.attr('id');
	var tabTitle = tabManager.getTitle(tab);
	tipManager.timer = setTimeout('tipManager.showTip("' 
			+ tabId + '", "mouseover", "tabTooltip", "' 
			+ tabTitle + '",' 
			+ event.pageX + ',' 
			+ event.pageY + ')', 500);	
};

tipManager.showCloseTabTip = function(closeTab) {
	clearTimeout(tipManager.timer);	
	
	var closeTabWidth = closeTab.width();
	var closeTabHeight = closeTab.height();
	var closeTabOffset = closeTab.offset();
	
	var tabId = closeTab.closest('.tab').attr('id');
	tipManager.timer = setTimeout('tipManager.showTip("' 
			+ tabId + '", "mouseover", "closeTabButtonTooltip", "", ' 
			+ closeTabOffset.left + ',' 
			+ closeTabOffset.top + ',' 
			+ closeTabWidth + ',' 
			+ closeTabHeight + ')', 500);		
};

tipManager.showFavbarTip = function(favItem, event) {
	clearTimeout(tipManager.timer);	
	
	var favId = favItem.attr('id');
	var favTitle = $(' span', favItem).html();
	tipManager.timer = setTimeout('tipManager.showTip("' 
			+ favId + '", "mouseover", "favTooltip", "' 
			+ favTitle + '",' 
			+ event.pageX + ',' 
			+ event.pageY + ')', 500);		
};